#----------------------------------------------------------------------
#             Answers to exercises of Chapter 7
#                     Multiple Testing
#----------------------------------------------------------------------

#----------------------------------------------------------------------
#                      Lab session 1
#----------------------------------------------------------------------

#----------------------------------------------------------------------
#                       Exercise 1.1
#----------------------------------------------------------------------
#----------------------- question 1 -----------------------------------
Y<-readRDS("data/LenzT.rds")
X<-readRDS("data/LenzI.rds")
names(X)
dim(Y)
rg <- sample(rownames(LenzT), 1000)               # random genes
Y <- Y[,rg]                                       # sub-matrix of Y
#----------------------- question 2 -----------------------------------
pregim<-apply(Y,2,function(v){t.test(v~X$regim)$p.value})
sum(pregim<0.05)                                  # number of p-values below 5%
#----------------------- question 3 -----------------------------------
pregimadB<-p.adjust(pregim,method="bonferroni")   # p-values adjusted by Bonferroni
sort(pregimadB)[1:10]                             # ten genes with the smallest p-values
names(sort(pregimadB)[1:10])                      # names of the ten first genes
sum(pregimadB<0.05)                               # number of p-values below 5%
#----------------------- question 4 -----------------------------------
pregimadBH<-p.adjust(pregim,method="BH")          # p-values adjusted by Benjamini-Hochberg
sum(pregimadBH<0.05)                              # number of p-values below 5%
pregimadBY<-p.adjust(pregim,method="BY")          # p-values adjusted by Benjamini-Yekutieli
sum(pregimadBY<0.05)                              # number of p-values below 5%
#----------------------- question 5 -----------------------------------
plot(ecdf(pregim))       
lines(ecdf(pregimadB), col="red")
lines(ecdf(pregimadBH), col="green")
lines(ecdf(pregimadBY), col="blue")
#----------------------- question 6 -----------------------------------
sort(pregimadBH)[1:10]
names(sort(pregimadBH)[1:10])
sort(pregimadBY)[1:10]
names(sort(pregimadBY)[1:10])
#----------------------- question 7 -----------------------------------
pregimvar<-apply(Y,2,function(v){var.test(v~X$regim)$p.value})
pregimvaradBY<-p.adjust(pregimvar,method="BY")    # p-values adjusted by Benjamini-Yekutieli
sort(pregimvaradBY)[1:10]
names(sort(pregimvaradBY)[1:10])
#----------------------- question 8 -----------------------------------
pregimw<-apply(Y,2,function(v){wilcox.test(v~X$regim)$p.value})
pregimwadBY<-p.adjust(pregimw,method="BY")        # p-values adjusted by Benjamini-Yekutieli
sort(pregimwadBY)[1:10]
names(sort(pregimwadBY)[1:10])


#----------------------------------------------------------------------
#                       Exercise 1.2
#----------------------------------------------------------------------
#----------------------- question 1 -----------------------------------
Y<-readRDS("data/LenzT.rds")
X<-readRDS("data/LenzI.rds")
names(X)
dim(Y)
rg <- sample(rownames(LenzT), 1000)               # random genes
Y <- Y[,rg]                                       # sub-matrix of Y
#----------------------- question 2 -----------------------------------
page<-apply(Y,2,function(v){cor.test(v,X$age)$p.value})
sum(page<0.05)                                    # number of p-values below 5%
#----------------------- question 3 -----------------------------------
pageadB<-p.adjust(page,method="bonferroni")       # p-values adjusted by Bonferroni
sum(pageadB<0.05)
sort(pageadB)[1:10]                               # ten genes with the smallest p-values
names(sort(pageadB)[1:10])                        # names of the ten first genes
#----------------------- question 4 -----------------------------------
pageadBH<-p.adjust(page,method="BH")        # p-values adjusted by Benjamini-Hochberg
sum(pageadBH<0.05)
sort(pageadBH)[1:10]
names(sort(pageadBH)[1:10])
pageadBY<-p.adjust(page,method="BY")        # p-values adjusted by Benjamini-Yekutieli
sum(pageadBY<0.05)
sort(pageadBY)[1:10]
names(sort(pageadBY)[1:10])
#----------------------- question 5 -----------------------------------
plot(ecdf(page))       
lines(ecdf(pageadB), col="red")
lines(ecdf(pageadBH), col="green")
lines(ecdf(pageadBY), col="blue")
#----------------------- question 6 -----------------------------------
pstage<-apply(Y,2,function(v){oneway.test(v~X$stage)$p.value})
sum(pstage<0.05)
sort(pstage)[1:10]
plot(density(pstage))
#----------------------- question 7 -----------------------------------
pstageadBY<-p.adjust(pstage,method="BY")        # p-values adjusted by Benjamini-Yekutieli
sum(pstageadBY<0.05)
sort(pstageadBY)[1:10]
sum(pstageadBY<0.05)
names(sort(pstageadBY)[1:10])
