#----------------------------------------------------------------------
#             Answers to exercises of Chapter 4
#                     Statistical tests
#----------------------------------------------------------------------
#----------------------------------------------------------------------
#                      Session 1
#----------------------------------------------------------------------

#----------------------------------------------------------------------
#                       Exercise 1.1
#----------------------------------------------------------------------
#----------------------- question 1 -----------------------------------
mu <- 1000; sig <- 20                       # mean and standard deviation
# H0: "mu equals 1000" against H1: "mu different from 1000"
# decision rule: reject H0 if weight outside
qnorm(c(0.025,0.975),mu,sig)                # at threshold 5%
qnorm(c(0.005,0.995),mu,sig)                # at threshold 1%
#----------------------- question 2 -----------------------------------
# H0: "mu equals 1000" against H1: "mu larger than 1000"
# decision rule: reject H0 if weight larger than 
qnorm(0.95,mu,sig)                          # at threshold 5%
qnorm(0.99,mu,sig)                          # at threshold 1%
#----------------------- question 3 -----------------------------------
pnorm(1018,mu,sig,lower.tail=FALSE)         # p-value
#----------------------- question 4 -----------------------------------
# H0: "mu equals 1000" against H1: "mu smaller than 1000"
# decision rule: reject H0 if weight smaller than 
qnorm(0.05,mu,sig)                          # at threshold 5%
qnorm(0.01,mu,sig)                          # at threshold 1%
#----------------------- question 5 -----------------------------------
pnorm(982,mu,sig)                           # p-value

#----------------------------------------------------------------------
#                        Exercise 1.2
#----------------------------------------------------------------------

#----------------------- question 1 -----------------------------------
mu <- 150; sig <- 5                         # mean and standard deviation
# H0: "mu equals 150" against H1: "mu smaller than 150"
# decision rule: reject H0 if concentration smaller than
qnorm(0.05,mu,sig)                          # at threshold 5%
#----------------------- question 2 -----------------------------------
pnorm(140,mu,sig)                           # p-value
# p-value=0.023<0.05, H0 rejected, the patient is not at risk

#----------------------------------------------------------------------
#                       Exercise 1.3
#----------------------------------------------------------------------

#----------------------- question 1 -----------------------------------
m <- 5; s <- 0.04                           # parameters for H0
2*pnorm(5.07,m,s,lower.tail=FALSE)          # two sided test
normal.pvalue(5.07,m,s,alternative="two.sided")
# p-value=0.08>0.05, accept H0: the value is not unusual

pnorm(5.07,m,s,lower.tail=FALSE)            # right sided test
normal.pvalue(5.07,m,s,alternative="greater")
# p-value=0.04<0.05, reject H0: the value is too high

pnorm(4.93,m,s)                             # left sided test
normal.pvalue(4.93,m,s,alternative="less")
#  p-value=0.04<0.05, reject H0: the value is too small, the patient is anemic

#----------------------------------------------------------------------
#                       Exercise 1.4
#----------------------------------------------------------------------

#----------------------- question 1 -----------------------------------
x<- 20; n<- 30; freq <- x/n; p <- 19/37     # loosing
2*pnorm(freq,p,sqrt(p*(1-p)/n),lower.tail=FALSE)
prop.test(x,n,p,alternative="two.sided")$p.value
x<- 10; n<- 30; freq <- x/n; p <- 18/37      # winning (same results)
2*pnorm(freq,p,sqrt(p*(1-p)/n))
prop.test(x,n,p,alternative="two.sided")$p.value
# p-value=0.135>0.05, accept H0: nothing unusual

x<- 30; n<- 40; freq <- x/n; p <- 18/37     # winning
2*pnorm(freq,p,sqrt(p*(1-p)/n),lower.tail=FALSE)
prop.test(x,n,p,alternative="two.sided")$p.value
# p-value=0.0015<0.05, reject H0: this is an unusual result

x<- 55; n<- 100; freq <- x/n; p <- 18/37    # winning
pnorm(freq,p,sqrt(p*(1-p)/n),lower.tail=FALSE)
prop.test(x,n,p,alternative="greater")$p.value
# p-value=0.121>0.05, accept H0: this can happen without cheating

x<- 552; n<- 935; freq <- x/n; p <- 19/37   # loosing
pnorm(freq,p,sqrt(p*(1-p)/n),lower.tail=FALSE)
prop.test(x,n,p,alternative="greater")$p.value
# p-value=1.51e-06, reject H0: he should stop gambling
